/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.definition.animation;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public sealed interface DoubleOrString {
    public boolean isDouble();

    public double doubleValue();

    public String stringValue();

    public static JsonDeserializer<DoubleOrString> gsonDeserializer() throws JsonParseException {
        return (json, type, context) -> {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("DoubleOrString encountered invalid format, expected either String or double: " + String.valueOf(json));
            }
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isString()) {
                return new StringValue(primitive.getAsString());
            }
            return new DoubleValue(primitive.getAsDouble());
        };
    }

    public record StringValue(String stringValue) implements DoubleOrString
    {
        @Override
        public boolean isDouble() {
            return false;
        }

        @Override
        public double doubleValue() {
            throw new IllegalStateException("Attempted to retrieve a double value from a String-type DoubleOrString!");
        }
    }

    public record DoubleValue(double doubleValue) implements DoubleOrString
    {
        @Override
        public boolean isDouble() {
            return true;
        }

        @Override
        public String stringValue() {
            throw new IllegalStateException("Attempted to retrieve a String value from a double-type DoubleOrString!");
        }
    }
}

